<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section, opens the <body> tag and adds the site's header
 */
?><!doctype html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo('charset'); ?>"/>
    <meta name="viewport" content="width=device-width, initial-scale=1"/>
    <link rel="profile" href="https://gmpg.org/xfn/11"/>
    <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php wp_body_open(); ?>
<div id="page" class="site">

    <header id="masthead" class="site-header">

        <div class="site-branding-container">
            <?php get_template_part('template-parts/header'); ?>
        </div><!-- .layout-wrap -->

    </header><!-- #masthead -->

    <div id="content" class="site-content">
